/*------------------------------------------------------------------------------*
 * File Name: spc_utils.h				 										*
 * Creation: AW 11/20/2006														*
 * Purpose: OriginC Source C file												*
 * Copyright (c) Originlab Corp. 2006, 2007, 2008								*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	Cheney 2006-12-5 READ_3D_DATA_TO_MATRIX_IF_X_Z_EVENLY_SPACED				*	
 *	Cheney 2006-12-7 PREPARE_TRINFO_WHICH_WANT_TO_SHOW_IN_ORGANIZER				*
 *	Cheney 2006-12-7 SET_COLUMN_PROPERTY										*
 *	Cheney 2006-12-9 PREPARE_ERR_MESSAGE										*
 *	Cheney 2007-1-25 CHECK_IF_SET_SAMPLE_INTERVAL								*
 *	Hong 04/21/08 QA80-7225 ADD_OPTION_CONTROL_WHETHER_RENAME_COL_SNAME			*
 *	Hong 07/01/08 QA80-11784 BRING_BACK_SPC_COLUMN_CORNER_INFO					*
 *	Hong 08/08/08 QA80-11784 FIX_CRASH_WHEN_IMPORT_MULTI_FILE_AT_ONCE			*
 *------------------------------------------------------------------------------*/

 
#ifndef _SPC_FILE_H
#define _SPC_FILE_H

#include "file_utils.h"	///---Sim 02-07-2007 GENERAL_IMPORT_CLASS

enum spcWarning
{
    spcWarningNone = 0,
    spcWarningNSub = -1,
    spcWarningWPlane = -2,
    spcWarningLogOff = -3,
    spcWarningLogBinS = -4,
    spcWarningLogDskS = -5,
    spcWarningCatOff = -6
};

enum spcErro
{
	spcErrorNone			= 0,
	spcErrorInitFailed		= 1,
	spcErrorInvalidDataFile	= 2,
	///Cheney 2006-12-9 PREPARE_ERR_MESSAGE
	/////Cheney 2006-12-5 READ_3D_DATA_TO_MATRIX_IF_X_Z_EVENLY_SPACED
	//spcErrorCannotImpToMat	= 3,
	/////end READ_3D_DATA_TO_MATRIX_IF_X_Z_EVENLY_SPACED
	//spcErrorUnsupportNonevntSPCInMAt	= 4
	spcErrorNoZAxis			= 3,
	spcErrorZNotEven		= 4,
	spcErrorXNotEven		= 5
	///end PREPARE_ERR_MESSAGE
};

///Cheney 2006-12-7 PREPARE_TRINFO_WHICH_WANT_TO_SHOW_IN_ORGANIZER
enum spcTechType
{
    spcTechGen = 0,
    spcTechGC = 1,
    spcTechCgm = 2,
    spcTechHPLC = 3,
    spcTechFTIR = 4,
    spcTechNIR = 5,
    spcTechUV = 7,
    spcTechXry = 8,
    spcTechMS = 9,
    spcTechNMR = 10,
    spcTechRmn = 11,
    spcTechFlr = 12,
    spcTechAtm = 13,
    spcTechDAD = 14,
    spcTechThrm = 15,
    spcTechCD = 16,
    spcTechCNMR = 20,
    spcTechHNMR = 21,
    spcTechDNMR = 22,
    spcTechANMR = 23
};

enum spcFileType
{
    spcFileTypeEven = 0,
    spcFileTypeXYY = 1,
    spcFileTypeXYXY = 2
};
///end PREPARE_TRINFO_WHICH_WANT_TO_SHOW_IN_ORGANIZER

/// Hong 04/21/08 QA80-7225 ADD_OPTION_CONTROL_WHETHER_RENAME_COL_SNAME
#define 	MAX_COL_SHORT_NAME		10
enum {
	SPC_RENAME_SNAME	= 0x00000001,
};
/// end ADD_OPTION_CONTROL_WHETHER_RENAME_COL_SNAME

class SPCFile : public BinFile	///---Sim 02-07-2007 GENERAL_IMPORT_CLASS
{ 
public:
	SPCFile();//BOOL bImport = true);
	~SPCFile(); /// Hong 07/01/08 QA80-11784 BRING_BACK_SPC_COLUMN_CORNER_INFO
public:	
	int Import(Datasheet& ds, LPCTSTR lpszFileName, TreeNode& trInfo, int nC1 = 0, DWORD dwOption = 0); 
	///Cheney 2007-1-25 CHECK_IF_SET_SAMPLE_INTERVAL
	bool IfSetSampInterv(){ return m_bSetSampInterv; }
	///end CHECK_IF_SET_SAMPLE_INTERVAL
protected:
	int Open(LPCTSTR lpszFileName);
	int ReadData(Datasheet& ds, int nC1 = 0, DWORD dwOption = 0);
	
	/// Hong 04/21/08 QA80-7225 ADD_OPTION_CONTROL_WHETHER_RENAME_COL_SNAME
	//int ReadXDataToCol(int nCol, int nSubFileIndex);
	//int ReadYDataToCol(int nCol, int nSubFileIndex);
	int ReadXDataToCol(int nCol, int nSubFileIndex, DWORD dwOption = 0);
	int ReadYDataToCol(int nCol, int nSubFileIndex, DWORD dwOption = 0);
	/// end ADD_OPTION_CONTROL_WHETHER_RENAME_COL_SNAME
	int ReadDataToWks(int nTotalRows, int nTotalCols, int nC1 = 0, DWORD dwOption = 0);
	///Cheney 2006-12-5 READ_3D_DATA_TO_MATRIX_IF_X_Z_EVENLY_SPACED
	int ReadDataToMat(int nTotalRows, int nTotalCols, DWORD dwOption = 0);
	//int ReadDataToEachMatLayer(int nTotalLayerRows, int nTotalLayerCols, DWORD dwOption, int nLayerIndex, double x1, double x2);
	///end READ_3D_DATA_TO_MATRIX_IF_X_Z_EVENLY_SPACED
	int ReadDataToEachMatObj(int nWPlantIndex, int nTotalLayerRows, int nTotalLayerCols, double x1, double x2, double z1, double z2, DWORD dwOption = 0);
///Cheney 2006-12-7 SET_COLUMN_PROPERTY
private:
	/// Hong 07/01/08 QA80-11784 BRING_BACK_SPC_COLUMN_CORNER_INFO
	bool	readMainHeaderInfo();
	bool	readSubHeaderInfo(int nSubFileIndex, const Column& col);
	void	getMainHeader(OSPCMAINHeader& spcMainHeader);
	void	getSubHeader(OSPCSUBHeader& spcSubHeader, int nSubFileIndex, const Column& col);
	/// end BRING_BACK_SPC_COLUMN_CORNER_INFO
	
	double	getWForEachSubfile(int nSubFile);
	bool	handleColumnProperty(Column& col, int nSubFileIndex);
	///Cheney 2006-12-22 SET_UNIT_AND_LONGNAME
	bool	prepareLabelAndUnit(TreeNode& trUbitLabel, string& strLabel, string& strUnit);
	bool	prepareColumnProperty();
	///end SET_UNIT_AND_LONGNAME
///end SET_COLUMN_PROPERTY
	void 	safeFreeSPCInfo(); /// Hong 08/08/08 QA80-11784 FIX_CRASH_WHEN_IMPORT_MULTI_FILE_AT_ONCE	

protected:
	/// Hong 07/01/08 QA80-11784 BRING_BACK_SPC_COLUMN_CORNER_INFO
	SPCData*	m_pSPCInfos;
	/// end BRING_BACK_SPC_COLUMN_CORNER_INFO
	BOOL		m_bValid;
	Object  	m_SPCIO;
	Tree 		m_trHeader;
	Worksheet	m_wks;
	MatrixLayer	m_mlayer;
	///Cheney 2007-1-25 CHECK_IF_SET_SAMPLE_INTERVAL
	bool 		m_bSetSampInterv;
	LPCTSTR 	m_lpszFileName;
	///end CHECK_IF_SET_SAMPLE_INTERVAL
};

#endif	//_SPC_FILE_H